--[[
--CTF/Lua
--By Darren Watts (W'rkncacnter)
--]]

CAPTURES = 7
team1_flag = {} --Polygon of team 1's flag
team2_flag = {} --Polygon of team 2's flag
team1_bases = {} --Polygons for team1
team2_bases = {} --Polygons for team2
teams = {}
team1_flag_in_base = true
team2_flag_in_base = true
player_has_flag = {}
count1 = 0
count2 = 0
points = {}
kills = {}
original_teams = {}
original_colors = {}
team1_color = 1
team2_color = 6
flash_color = 4
finish_off = false
end_timer = 0
has_ended = false

function init()
	initialize_vars()
	set_base_polys()
	check_teams()
	players_to_bases()
	place_flags()
end

function initialize_vars()
	for i = 1, number_of_players(), 1 do
		player_has_flag[i] = false
		points[i] = 0
	end
	for i = 0, number_of_players(), 1 do
		kills[i] = {}
		for k = 0, number_of_players(), 1 do
			kills[i][k] = 0
		end
	end
end

function set_base_polys()
	for i = 0, number_of_polygons() - 1, 1 do
		if(get_polygon_type(i) == _polygon_is_visible_monster_trigger) then
			team1_flag = i
		end
		if(get_polygon_type(i) == _polygon_is_invisible_monster_trigger) then
			team2_flag = i
		end
		if(get_polygon_type(i) == _polygon_is_dual_monster_trigger) then
			team1_bases[table.getn(team1_bases) + 1] = i
		end
		if(get_polygon_type(i) == _polygon_must_be_explored) then
			team2_bases[table.getn(team2_bases) + 1] = i
		end
	end
end

function check_teams()
	local red_team_exists = false
	local blue_team_exists = false
	for i = 0, number_of_players() - 1, 1 do
		if(get_player_team(i) == team1_color) then
			red_team_exists = true
		elseif(get_player_team(i) == team2_color) then
			blue_team_exists = true
		end
	end
	if(red_team_exists == false and blue_team_exists == false) then
		assign_teams(0)
	elseif(red_team_exists == true and blue_team_exists == false) then
		assign_teams(1)
	elseif(red_team_exists == false and blue_team_exists == true) then
		assign_teams(2)
	else
		assign_teams(3)
	end
end

function assign_teams(num)
	if(num == 0) then
		num = math.mod (better_random (), number_of_players())
		teams[1] = get_player_team(num)
		for i = 0, number_of_players() - 1, 1 do --Split into teams.
			if (get_player_team(i) ~= teams[1]) then
				teams[table.getn(teams) + 1] = get_player_team(i)
			end
		end
		for i = 0, number_of_players() - 1, 1 do
			if (get_player_team(i) == teams[1]) then
				set_player_team(i, team1_color)
				set_player_color(i, team1_color)
				original_teams[i+1] = team1_color
				original_colors[i+1] = get_player_color(i)
			else
				set_player_team(i, team2_color)
				set_player_color(i, team2_color)
				original_teams[i+1] = team2_color
				original_colors[i+1] = get_player_color(i)
			end
		end
	end
	if(num == 1 or num == 3) then
		for i = 0, number_of_players() - 1, 1 do
			if (get_player_team(i) == team1_color) then
				set_player_team(i, team1_color)
				set_player_color(i, team1_color)
				original_teams[i+1] = team1_color
				original_colors[i+1] = get_player_color(i)
			else
				set_player_team(i, team2_color)
				set_player_color(i, team2_color)
				original_teams[i+1] = team2_color
				original_colors[i+1] = get_player_color(i)
			end
		end
	end
	if(num == 2) then
		for i = 0, number_of_players() - 1, 1 do
			if(get_player_team(i) == team2_color) then
				set_player_team(i, team2_color)
				set_player_color(i, team2_color)
				original_teams[i+1] = team2_color
				original_colors[i+1] = get_player_color(i)
			else
				set_player_team(i, team1_color)
				set_player_color(i, team1_color)
				original_teams[i+1] = team1_color
				original_colors[i+1] = get_player_color(i)
			end
		end
	end
	teams[1] = team1_color
	teams[2] = team2_color
end

function players_to_bases()
	for i = 0, number_of_players() - 1, 1 do
		if original_teams[i+1] == teams[1] then
			poly = math.mod (better_random (), table.getn(team1_bases))
			teleport_player(i, team1_bases[poly+1])
		else
			poly = math.mod (better_random (), table.getn(team2_bases))
			teleport_player(i, team2_bases[poly+1])
		end
	end
end

function place_flags()
	new_item (_item_uplink_chip, team1_flag)
	new_item (_item_spht_door_key, team2_flag)
end

function idle()
	return_flag()
	update_count()
	make_sure_flag_exists()
	carrier_flash()
	compass_on()
	end_game()
	victory_sound()
end

function return_flag()
	for i = 0, number_of_players() - 1, 1 do
		if(original_teams[i+1] == teams[1]) then
			if(player_has_flag[i+1] == true and get_player_polygon(i) == team1_flag) then
				set_player_color(i, original_colors[i+1])
				player_has_flag[i+1] = false
				team2_flag_in_base = true
				points[i+1] = points[i+1] + 1
				remove_item (i, _item_spht_door_key)
				award_kills (i, i, -1)
				alert_captured(i, 1)
				check_if_end_game(1)
			end
		else
			if(player_has_flag[i+1] == true and get_player_polygon(i) == team2_flag) then
				set_player_color(i, original_colors[i+1])
				player_has_flag[i+1] = false
				team1_flag_in_base = true
				points[i+1] = points[i+1] + 1
				remove_item (i, _item_uplink_chip)
				award_kills (i, i, -1)
				alert_captured(i, 2)
				check_if_end_game(2)
			end
		end
	end
end

function alert_captured(player, num)
	if(num == 1) then
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[1] and i == player) then
				screen_print(i, "You have captured the enemy flag!")
			elseif(original_teams[i+1] == teams[1] and i ~= player) then
				screen_print(i, "Your team has captured the enemy flag!")
			elseif(original_teams[i+1] == teams[2]) then
				screen_print(i, "The enemy has captured your flag!")
			end
		end
	else
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[2] and i == player) then
				screen_print(i, "You have captured the enemy flag!")
			elseif(original_teams[i+1] == teams[2] and i ~= player) then
				screen_print(i, "Your team has captured the enemy flag!")
			elseif(original_teams[i+1] == teams[1]) then
				screen_print(i, "The enemy has captured your flag!")
			end
		end
	end
end

function update_count()
	if(count1 > 0) then
		count1 = count1 - 1
	end
	if(count2 > 0) then
		count2 = count2 - 1
	end
	if(end_timer > 0) then
		end_timer = end_timer - 1
	end
end

function make_sure_flag_exists()
	local flag1exists = false
	local flag2exists = false
	for i = 0, MAXIMUM_OBJECTS_PER_MAP-1, 1 do
		if (item_index_valid(i)) then
			if (get_item_type(i) == _item_uplink_chip) then
				flag1exists = true
			elseif (get_item_type(i) == _item_spht_door_key) then
				flag2exists = true
			end
		end
	end
	if(flag1exists == false and team1_flag_in_base == true and count1 <= 0) then
		new_item (_item_uplink_chip, team1_flag)
		count1 = 30
	end
	if(flag2exists == false and team2_flag_in_base == true and count2 <= 0) then
		new_item (_item_spht_door_key, team2_flag)
		count2 = 30
	end
end

function carrier_flash()
	for i = 0, number_of_players() - 1, 1 do
		if(player_has_flag[i+1] == true) then
			set_player_color(i, flash_color);
		elseif(player_has_flag[i+1] == true) then
			set_player_color(i, original_teams[i+1]);
		end
	end
end

function compass_on()
	local team1_has_flag = false
	local team2_has_flag = false
	local carrier_team1 = nil
	local carrier_team2 = nil
	for i = 0, number_of_players() - 1, 1 do
		if(player_has_flag[i+1] == true) then
			if(original_teams[i+1] == teams[1]) then
				carrier_team1 = i
				team1_has_flag = true
			else
				carrier_team2 = i
				team2_has_flag = true
			end
		end
	end
	for i = 0, number_of_players() - 1, 1 do
		if(player_has_flag[i+1] == false and original_teams[i+1] == 1) then
			if(team2_has_flag == true) then
				x, y, z = get_player_position(carrier_team2)
				set_lua_compass_beacon (i, x, y)
				set_lua_compass_state (i, _network_compass_use_beacon)
				use_lua_compass(i, true)
			end
		end
		if(player_has_flag[i+1] == false and original_teams[i+1] == teams[2]) then
			if(team1_has_flag == true) then
				x, y, z = get_player_position (carrier_team1)
				set_lua_compass_beacon (i, x, y)
				set_lua_compass_state (i, _network_compass_use_beacon)
				use_lua_compass(i, true)
			end
		end
		if(team1_has_flag == false and team2_has_flag == false) then
			use_lua_compass(i, false)
		end
	end
end

function got_item(type, player)
	if(original_teams[player+1] == teams[1]) then
		if(type == _item_spht_door_key) then
			player_has_flag[player+1] = true
			alert_teams(1)
			team2_flag_in_base = false
		end
		if(type == _item_uplink_chip and team1_flag_in_base == true) then
			deny_pickup(player)
		end
		if(type == _item_uplink_chip and team1_flag_in_base == false) then
			save_flag(player)
		end
	elseif(original_teams[player+1] == teams[2]) then
		if(type == _item_uplink_chip) then
			player_has_flag[player+1] = true
			alert_teams(2)
			team1_flag_in_base = false
		end
		if(type == _item_spht_door_key and team2_flag_in_base == true) then
			deny_pickup(player)
		end
		if(type == _item_spht_door_key and team2_flag_in_base == false) then
			save_flag(player)
		end
	end
end

function alert_teams(num)
	if(num == 1) then
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[1] and player_has_flag[i+1] == true) then
				screen_print(i, "You have the enemy flag!")
			elseif(original_teams[i+1] == teams[1] and player_has_flag[i+1] == false) then
				screen_print(i, "Your team has the enemy flag!")
			elseif(original_teams[i+1] == teams[2]) then
				screen_print(i, "Your flag has been taken!")
			end
		end
	else
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[2] and player_has_flag[i+1] == true) then
				screen_print(i, "You have the enemy flag!")
			elseif(original_teams[i+1] == teams[2] and player_has_flag[i+1] == false) then
				screen_print(i, "Your team has the enemy flag!")
			elseif(original_teams[i+1] == teams[1]) then
				screen_print(i, "Your flag has been taken!")
			end
		end
	end
end

function player_killed(player, aggressor_player, action, projectile)
	player_has_flag[player+1] = false
	set_player_color(player, original_colors[player+1])
	kills[aggressor_player+1][player+1] = kills[aggressor_player+1][player+1] + 1
	award_kills (aggressor_player, player, -1)
end

function player_revived(player)
	if original_teams[player+1] == teams[1] then
		poly = math.mod (better_random (), table.getn(team1_bases))
		teleport_player(player, team1_bases[poly+1])
	else
		poly = math.mod (better_random (), table.getn(team2_bases))
		teleport_player(player, team2_bases[poly+1])
	end
end

function check_if_end_game(num)
	local total_points = 0
	for i = 0, number_of_players() - 1, 1 do
		if(original_teams[i+1] == teams[num]) then
			total_points = total_points + points[i+1]
		end
	end
	if(total_points >= CAPTURES) then
		if(num == 1) then team = "RED" else team = "BLUE" end
		screen_print(team .. " team wins!")
		finish_off = true
		end_timer = 100
	end
end

function end_game()
	if(finish_off == true and end_timer <= 0 and has_ended == false) then
		for i = 0, number_of_players() - 1, 1 do
			 teleport_player_to_level (i, 256)
		end
		has_ended = true
	end
end

function deny_pickup(player)
	if(original_teams[player+1] == teams[1]) then
		remove_item(player, _item_uplink_chip)
	else
		remove_item(player, _item_spht_door_key)
	end
end

function save_flag(player)
	if(original_teams[player+1] == teams[1]) then
		new_item (_item_uplink_chip, team1_flag)
		team1_flag_in_base = true
		remove_item(player, _item_uplink_chip)
		save_flag_message(1)
	else
		new_item (_item_spht_door_key, team2_flag)
		team2_flag_in_base = true
		remove_item(player, _item_spht_door_key)
		save_flag_message(2)
	end
end

function save_flag_message(num)
	if(num == 1) then
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[1]) then
				screen_print(i, "Your flag has been returned!")
			elseif(original_teams[i+1] == teams[2]) then
				screen_print(i, "The enemy's flag was returned!")
			end
		end
	else
		for i = 0, number_of_players() - 1, 1 do
			if(original_teams[i+1] == teams[2]) then
				screen_print(i, "Your flag has been returned!")
			elseif(original_teams[i+1] == teams[1]) then
				screen_print(i, "The enemy's flag was returned!")
			end
		end
	end
end

function victory_sound()
	if(end_timer == 90) then
		play_sound(local_player_index(), _snd_adjust_volume, 1)
	elseif(end_timer == 80) then
		play_sound(local_player_index(), _snd_adjust_volume, 1)
	elseif(end_timer == 70) then
		play_sound(local_player_index(), _snd_adjust_volume, 1)
	end
end

function cleanup()
	for i = 0, number_of_players() - 1, 1 do
		for k = -1, number_of_players() - 1, 1 do
			temp = kills[i+1][k+1]
			for a = 0, temp - 1, 1 do
				award_kills(i,k,1)
			end
		end
	end
	for i = 0, number_of_players() - 1, 1 do
		for k = 0, number_of_players() - 1, 1 do
			set_kills(i, k, 0)
		end
		set_kills(i,i,points[i+1])
		set_player_color(i, original_colors[i+1])
		set_player_team(i, original_teams[i+1])
	end
end